<?php

/** Include database */
require_once "../database/database.php";

/** Define money_format locale */
setlocale(LC_MONETARY, 'en_US');

/** If edit */
if ($_POST['action']) {

/** Clean String */
$cleanP = file_get_contents("php://input");
$cleanP = str_replace("%5B", "[", $cleanP);
$cleanP = str_replace("%5D", "]", $cleanP);
$cleanP = str_replace("%2F", "/", $cleanP);
$cleanP = str_replace("%3A", ":", $cleanP);
$cleanP = str_replace("%2C", ",", $cleanP);
$cleanP = str_replace("%25", "%", $cleanP);
$cleanP = str_replace("+", " ", $cleanP);
$cleanP = str_replace("data[", "", $cleanP);

/** Cleaned string */
$cleanedString = strtok($cleanP, '&');

/** Get updated ID */
$updatedID = strtok($cleanedString, '][');

/** Get updated value */
$updatedValue = substr(strstr($cleanedString, '='), 1);

/** Get updated column */
$updatedColumn = str_replace($updatedID, "", $cleanedString);
$updatedColumn = str_replace($updatedValue, "", $updatedColumn);
$updatedColumn = str_replace("][", "", $updatedColumn);
$updatedColumn = str_replace("]=", "", $updatedColumn);

/** Update database */
$registration_db->query("UPDATE tracker SET $updatedColumn = '$updatedValue' WHERE ID = '$updatedID'");

}

?>
{
  "data": [
<?php

/** GET trackerID */
$trackerID = $_GET['trackerID'];

/** Include configurator based on Tracker ID */
include "/home/graytraining/public_html/includes/courses/tracker/configurator/$trackerID.php";

/** Run SQL query */
$result = $registration_db->query("SELECT * FROM tracker WHERE table_ID = '$trackerID' ORDER BY ID DESC;");

$numRows = mysqli_num_rows($result);

$i = 1;
         
while($row = $result->fetch_array()) {

/** Get columns */
$ID = $row[ID];
$table_ID = $row[table_ID];

$client = $row[client];
$type = $row[type];
$seller = $row[seller];
$cna = $row[cna];
$annual_budget = $row[annual_budget];
$share_goal = $row[share_goal];
$goal = $row[goal];
$bgp = $row[bgp];
$client_meeting = $row[client_meeting];
$callType = $row[callType];
$status = $row[status];
$confidence = $row[confidence];
$multiPlatformRevenue = $row[multiPlatformRevenue];
$tv = $row[tv];
$other = $row[other];
$digital = $row[digital];
$production = $row[production];
$total = $row[total];
$comments = $row[comments];

/** Get Call Planner columns */
$callPlanner_A = $row[callPlanner_A];
$callPlanner_B = $row[callPlanner_B];
$callPlanner_CD = $row[callPlanner_CD];
$callPlanner_E = $row[callPlanner_E];
$callPlanner_F = $row[callPlanner_F];

/** Combine A,B,C,D,E,F columns */
$callPlanner_combined = "$callPlanner_A$callPlanner_B$callPlanner_CD$callPlanner_E$callPlanner_F";

/** Define Call Planner icon color */
if ($callPlanner_combined == "") { $callPlanner_icon = "callplanner.svg"; } else { $callPlanner_icon = "callplanner_green.png"; }

/** Last comma */
if ($i == $numRows) { $comma = ""; } else { $comma = ","; }

/** Annual Budget * Share Goal = Goal ($) */
$goal = $annual_budget * ($share_goal/100);
$goal = round($goal / 100) * 100;

/** Goal if Annual Budget is empty */
if ($annual_budget == "") { $goal = ""; }

/** Goal if Share Goal is empty */
if ($share_goal == "") { $goal = ""; }

/** Define multiPlatform */
if ($multiPlatformRevenue == '' || $multiPlatformRevenue == '0' || $multiPlatformRevenue == '$0') { $multiPlatformRevenue = '<span data-id=\''.$ID.'\' data-client=\"'.$client.'\" data-tv=\''.$tv.'\' data-other=\''.$other.'\' data-digital=\''.$digital.'\' data-production=\''.$production.'\' data-total=\''.$multiPlatformRevenue.'\' class=\'span-multiPlatformRevenue span-multiPlatformRevenue_open_'.$table_ID.'\'><img class=\'span-dollarGreen\' src=\'https://static.graytraining.tv/dashboard/assets/media/icons/cashicon.svg\' style=\'height: 16px; position: relative;\'></span>'; } else {

  $multiPlatformRevenue = '<span data-toggle=\'tooltip\' data-placement=\'top\' data-html=\'true\' title=\'TV: '.$tv.'<br>Digital: '.$digital.'<br>Prod: '.$production.'<br>Other: '.$other.'\' data-id=\''.$ID.'\' data-client=\"'.$client.'\" data-tv=\''.$tv.'\' data-other=\''.$other.'\' data-digital=\''.$digital.'\' data-production=\''.$production.'\' data-total=\''.$multiPlatformRevenue.'\' class=\'span-multiPlatformRevenueGreen span-multiPlatformRevenue_open_'.$table_ID.'\'>$'.$multiPlatformRevenue.'</span>';

}

/** Define comments image */
if ($comments == "") { $commentsIMG = "notes_off.svg"; } else { $commentsIMG = "notes_on.png"; }

/** Define Call Planner icon color */

/** Define Call Planner */
$callPlanner = '<span data-id=\''.$ID.'\' data-client=\"'.$client.'\" class=\'span-callPlanner_'.$table_ID.'\'><img class=\'span-dollarGreen\' src=\'https://static.graytraining.tv/courses/css/tracker/'.$callPlanner_icon.'\' style=\'height: 16px; position: relative;left:8px;\'></span>';

/** Output */
echo '
	 {
      "DT_RowId": "'.$ID.'",
      "client": "'.$client.'",
      "type": "'.$type.'",
      "seller": "'.$seller.'",
      "cna": "'.$cna.'",
      "annual_budget": "'.$annual_budget.'",
      "share_goal": "'.$share_goal.'",
      "goal": "'.$goal.'",
      "bgp": "'.$bgp.'",
      "client_meeting": "'.$client_meeting.'",
      "callType": "'.$callType.'",
      "callPlanner": "'.$callPlanner.'",
      "status": "'.$status.'",
      "confidence": "'.$confidence.'",
      "multiPlatformRevenue": "'.$multiPlatformRevenue.'",
      "actions": "<img data-client=\"'.$client.'\" data-comments=\"'.$comments.'\" data-id=\"'.$ID.'\" class=\"dt-comments_'.$trackerID.'\" src=\'https://static.graytraining.tv/courses/css/tracker/'.$commentsIMG.'\'> <img data-id=\"'.$ID.'\" class=\"dt-remove_'.$trackerID.'\" src=\'https://static.graytraining.tv/courses/css/tracker/delete.svg\'>"
    }'.$comma.'
	 ';

$i++;

}


?>
  ],
  "options": {
    "type": [
      <?php echo $type_json; ?>
    ],
    "bgp": [
      <?php echo $bgp_json; ?>
    ],
	"callType": [
      <?php echo $callType_json; ?>
    ],
    "status": [
      <?php echo $status_json; ?>
    ],
	"confidence": [
      <?php echo $confidence_json; ?>
    ]
  },
  "files": []
}